<?php

namespace EbsCommon;

function dump( $data, $label = '' ) {
	if ( $label ) {
		$label = "<h1>{$label}</h1>";
	}
	$data_p = print_r( $data, true );

	echo "<div class='ebs-dump'>{$label}<pre>{$data_p}</pre></div>";
}

function joinPaths() {
	$paths    = func_get_args();
	$last_key = func_num_args() - 1;
	array_walk( $paths,
		function ( &$val, $key ) use ( $last_key ) {
			switch ( $key ) {
				case 0:
					$val = rtrim( $val, '/ ' );
					break;
				case $last_key:
					$val = ltrim( $val, '/ ' );
					break;
				default:
					$val = trim( $val, '/ ' );
					break;
			}
		} );

	$first = array_shift( $paths );
	$last  = array_pop( $paths );
	$paths = array_filter( $paths ); // clean empty elements to prevent double slashes
	array_unshift( $paths, $first );
	$paths[] = $last;

	return implode( '/', $paths );
}

function addIf( &$array, $key, $value, $cb = null ) {
	$val = boolval( $value );

	if ( $cb ) {
		$val = call_user_func( $cb, $value );
	}

	if ( $val ) {
		$array[ $key ] = $value;
	}
}

/**
 * Gets a specific property within a multidimensional array.
 *
 * @param array  $array   The array to search in.
 * @param string $name    The name of the property to find.
 * @param string $default Optional. Value that should be returned if the property is not set or empty. Defaults to null.
 *
 * @return null|string|mixed The value
 * @since  Unknown
 * @access public
 *
 */
function rgars( $array, $name, $default = null ) {

	if ( ! is_array( $array ) && ! ( is_object( $array ) && $array instanceof ArrayAccess ) ) {
		return $default;
	}

	$names = explode( '/', $name );
	$val   = $array;
	foreach ( $names as $current_name ) {
		$val = rgar( $val, $current_name, $default );
	}

	return $val;
}

function abs_path_to_url( $path = '' ) {
	$url = str_replace(
		wp_normalize_path( untrailingslashit( ABSPATH ) ),
		site_url(),
		wp_normalize_path( $path )
	);

	return esc_url_raw( $url );
}

/**
 * Write data to a file with timestamp file name
 *
 * Filename is generated with $path/$name-$dateTime.$ext
 *
 * @param string $path      Directory to write file to
 * @param string $name      Name tag of file
 * @param mixed  $data      Data to write
 * @param string $ext       File extension
 * @param int    $timestamp Optional timestamp to use, defaults to time()
 *
 * @return string Path to file
 */
function writeTimestampedFile( $path, $name, $data, $ext, $timestamp = null ): string {
	if ( is_null( $timestamp ) ) {
		$timestamp = time();
	}

	$fileDate = strftime( '%Y-%m-%d_%H%M%S', $timestamp );
	$filePath = joinPaths( $path, "{$name}-{$fileDate}.{$ext}" );

	file_put_contents( $filePath, $data );

	return $filePath;
}

function emailDebugFiles( $to, $subject, $body, $attachments ) {
	$headers = [ 'Content-Type: text/html; charset=UTF-8' ];
	wp_mail( $to, $subject, $body, $headers, $attachments );
}

function arrayToCsv( $data, $delimiter = ",", $enclosure = '"', $escape_char = "\\" ) {
	$buffer = fopen( 'php://temp', 'r+' );
	foreach ( $data as $line ) {
		fputcsv( $buffer, $line, $delimiter, $enclosure, $escape_char );
	}
	rewind( $buffer );
	$result = stream_get_contents( $buffer );
	fclose( $buffer );

	return $result;
}

function writeFileToResponse( $fn, $data, $contentType = "application/octet-stream" ) {
	$contentLength = strlen( $data );
	header( "Content-Type: {$contentType}" );
	header( "Content-Disposition: attachment; filename=\"{$fn}\"" );
	header( 'Content-Transfer-Encoding: binary' );
	header( "Content-Length: {$contentLength}" );

	file_put_contents( 'php://output', $data );
}

/**
 * Insert a key-value pair into an associative array at a given position.
 *
 * @param array  $array    The original associative array.
 * @param string $key      The key to insert.
 * @param string $value    The value to insert.
 * @param int    $position The position at which to insert the key-value pair.
 *
 * @return array The modified associative array with the key-value pair inserted.
 */
function insertIntoAssociativeArray( array $array, string $key, string $value, int $position ): array {
	$result = [];
	$count  = 0;
	foreach ( $array as $k => $v ) {
		if ( $count == $position ) {
			$result[ $key ] = $value;
		}
		$result[ $k ] = $v;
		$count ++;
	}
	if ( $count <= $position ) {
		$result[ $key ] = $value;
	}

	return $result;
}

function is_divi_theme_builder_context() {
	global $post;

	// Check for Divi Theme Builder post type
	$is_theme_builder_post_type = $post && 'et_template' === get_post_type($post->ID);

	return $is_theme_builder_post_type;
}
