<?php

namespace EbsCommon\Wordpress\Modules;

/**
 * FAQs module
 *
 * @link       https://everbearingservices.com
 * @since      1.0.0
 *
 * @package    EbsCommon
 * @subpackage EbsCommon/includes/components/public
 */

use Carbon_Fields\Container;
use Carbon_Fields\Field;
use EbsCommon\Wordpress\Component;
use EbsCommon\Wordpress\TemplateLoader;

/**
 * FAQs module
 *
 * @package    EbsCommon
 * @author     Everbearing Services <info@everbearingservices.com>
 */
class FaqsComponent extends Component {
	protected $faqs;

	public function __construct( $plugin ) {
		parent::__construct( $plugin );
	}

	/**
	 *
	 * Module initialization
	 *
	 * @since 1.0.0
	 */
	protected function init() {
		parent::init();

		add_shortcode( 'faqs',
			function ( $atts ) {
				$atts = shortcode_atts( [
					'format'         => 'columns',
					'include_schema' => true,
					'count'          => - 1,
				],
					$atts,
					'faqs' );

				if ( is_null( $this->faqs ) ) {
					$this->faqs = carbon_get_theme_option( 'crb_questions' );
				}

				$schemaData = [
					"@context"   => "https://schema.org",
					"@type"      => "FAQPage",
					"mainEntity" => [],
				];

				$faqs = $this->faqs;
				if ( $atts['count'] > - 1 ) {
					$faqs = array_slice( $this->faqs, 0, $atts['count'] );
				}

				foreach ( $faqs as &$faq ) {
					$faq['answer'] = do_shortcode( $faq['answer'], false );

					$schemaData['mainEntity'][] = [
						'@type'          => 'Question',
						'name'           => $faq['question'],
						'acceptedAnswer' => [
							'@type' => 'Answer',
							'text'  => $faq['answer'],
						],
					];
				}

				return TemplateLoader::render( 'public/faqs.html.twig',
					[
						'format'         => $atts['format'],
						'count'          => $atts['count'],
						'include_schema' => $atts['include_schema'],
						'faqs'           => $faqs,
						'schemaJson'     => json_encode( $schemaData ),
					] );
			} );
	}

	public function registerCarbonFields(): void {
		$parentSlug = $this->plugin->getComponent( 'adminMenus' )->getMenuSlug();

		Container::make( 'theme_options', 'FAQs' )
		         ->set_page_parent( $parentSlug )
		         ->add_fields( [
			         Field::make( 'complex', 'crb_questions', __( 'Frequently Asked Questions', 'lpo-custom' ) )
			              ->set_layout( 'tabbed-vertical' )
			              ->add_fields( [
				              Field::make( 'text', 'question', 'Question' )
				                   ->set_required( true )
				                   ->set_help_text( 'Titles do not need to be UPCASED.  This is done automatically when displayed' ),
				              Field::make( 'text', 'slug', 'Slug' )
				                   ->set_required( true )
				                   ->set_help_text( 'This is used to generate named Anchor tag to allow # addressing in URLs' ),
				              Field::make( 'textarea', 'answer', 'Answer' )
				                   ->set_required( true )
				                   ->set_help_text( 'Use HTML tags for formatting' ),
			              ] )
			              ->set_help_text( 'Tab order determines display order' )
			              ->set_header_template( '
			              <% if (question) { %>
			                <%- question %>
			                <% } %>
			              ' ),
		         ] );
	}

}
