<?php

namespace EbsCommon\Wordpress;

class Interop {
	public static function get_plugins() {
		$updates = self::get_updates();

		$plugins = [];
		foreach ( get_plugins() as $id => $data ) {
			$slug = substr( $id, 0, strpos( $id, '/' ) );

			$newPlugin = [
				'id'      => $id,
				'slug'    => $slug,
				'name'    => $data['Name'],
				'version' => $data['Version'],
				'author'  => [
					'name' => $data['AuthorName'],
					'url'  => $data['AuthorURI'],
				],
				'update'  => [],
			];

			if ( array_key_exists( $id, $updates->response ) ) {
				$d                   = $updates->response[ $id ];
				$newPlugin['update'] = [
					'version'      => $d->new_version,
					'url'          => $d->url,
					'package'      => $d->package,
					'tested'       => $d->tested,
					'requires_php' => $d->requires_php,
				];
			}

			$plugins[ $slug ] = $newPlugin;
		}

		return $plugins;
	}

	public static function get_updates() {
		return get_site_transient( 'update_plugins' );
	}

	public static function get_comments_queue() {
		$comments = get_comments( [
			'status' => 'hold',
		] );
	}
}
