<?php

namespace EbsCommon\Wordpress\Traits;

trait FormHandlerTrait
{
    public static $form_handler_options = [
        'action' => '',
        'callback' => '',
    ];

    protected $form_handlers = [];

    /**
     * @param $options
     *
     * @return $this
     */
    public function addFormHandler($options) {
        $params = array_merge([], self::$form_handler_options, $options);

        add_action('wp_loaded',
            function () use ($params) {
                $action = '';
                if ($_SERVER['REQUEST_METHOD'] != 'POST') {
                    return;
                }

                if (isset($_REQUEST['action'])) {
                    $action = $_REQUEST['action'];
                } else {
                    return;
                }

                if ($action == $params['action']) {
                    // Process form
                    call_user_func($params['callback']);

                    $redirect_url = $_SERVER['REQUEST_URI'];
                    if (isset($form_handler['redirect']) && $params['redirect']) {
                        $redirect_url = $params['redirect'];
                    }

                    wp_redirect($redirect_url);
                    exit;
                }
            });

        return $this;
    }
}
