<?php

namespace EbsCommon\Wordpress;

class TemplateLoader {
	/**
	 * @var TemplateLoader Singleton instance
	 */
	protected static $instance = null;

	protected static $global_context = [];

	/**
	 * @var \Twig\Loader\FilesystemLoader Base Twig Loader
	 */
	protected static $loader;
	protected static $twig;

	public function __construct() {
		self::$loader = new \Twig\Loader\FilesystemLoader();

		self::$loader->addPath( __DIR__ . '/../templates' );

		self::$twig = new \Twig\Environment( self::$loader, [ 'debug' => true ] );
		self::$twig->addExtension( new \Twig\Extension\DebugExtension() );

		self::$twig->addFunction( new \Twig\TwigFunction( 'plugin_asset', [$this, 'twig_func_plugin_asset'] ) );
		self::$twig->addFunction( new \Twig\TwigFunction( 'do_shortcode', [$this, 'twig_func_do_shortcode'] ) );
		self::$twig->addFunction( new \Twig\TwigFunction( 'html_entity_decode', 'html_entity_decode' ) );

		self::$global_context = [];
	}

	public static function twig_func_plugin_asset($value) {
		return self::$global_context['PLUGIN']['base_url'] . 'assets/' . $value;
	}

	public static function twig_func_do_shortcode($value) {
		return do_shortcode($value);
	}

	public static function getInstance() {
		if ( self::$instance == null ) {
			self::$instance = new TemplateLoader();
		}

		return self::$instance;
	}

	public static function addTemplatePath( $path ) {
		self::$loader->addPath( $path );
	}

	public static function render( $template, $context = [] ) {
		return self::$twig->render( $template, array_merge( self::$global_context, $context ) );
	}

	public static function setContext( $context ) {
		self::$global_context = array_merge( self::$global_context, $context );
	}
}

TemplateLoader::getInstance();