<?php

namespace EbsCommon\Wordpress;

use Carbon_Fields\Container\Theme_Options_Container;
use Carbon_Fields\Field\Field;
use function EbsCommon\dump;

/**
 * Class SettingsBuilder
 * @package EbsCommon
 */
class SettingsBuilder {
	/**
	 * @var array
	 */
	protected $tabs;

	/**
	 * SettingsBuilder constructor.
	 */
	protected function __construct() {
		$this->tabs = [];
	}

	/**
	 * Create a new settings builder
	 *
	 * @return SettingsBuilder
	 */
	public static function make() {
		return new self();
	}

	/**
	 * Add a new tab to the collection
	 *
	 * @param string $name Tab name
	 * @param int $order Tab sort order
	 *
	 * @return TabBuilder
	 */
	public function addTab($name, $order) {
		$newTab = TabBuilder::make($name, $order);
		$this->tabs[] = $newTab;

		$this->sortTabs();

		return $newTab;
	}

	/**
	 * Get a Tab from colkection
	 *
	 * @param string $name
	 *
	 * @return TabBuilder|null
	 */
	public function getTab($name) {
		foreach ($this->tabs as $tab) {
			if ($tab['name'] == $name) {
				return $tab;
			}
		}

		return null;
	}

	/**
	 * Sort tabs in place
	 */
	protected function sortTabs() {
		usort($this->tabs, function ($a, $b) {
			/** @var TabBuilder $a */
			/** @var TabBuilder $b */
			if ($a->getOrder() == $b->getOrder()) {
				return 0;
			}
			return ($a->getOrder() < $b->getOrder()) ? -1 : 1;
		});
	}

	/**
	 * Apply SettingsBuilder to a Carbon Fields Container
	 *
	 * @param Theme_Options_Container $container
	 */
	public function apply($container) {
		$this->sortTabs();
		/** @var TabBuilder $tab */
		foreach ($this->tabs as $tab) {
			$container->add_tab($tab->getName(), $tab->getItemsArray());
		}
	}
}