<?php

namespace EbsCommon\Wordpress;

use Exception;

interface IException {
	/* Protected methods inherited from Exception class */
	public function __construct( $message = null, $code = 0 );                 // Exception message

	public function getMessage();                    // User-defined Exception code

	public function getCode();                    // Source filename

	public function getFile();                    // Source line

	public function getLine();                   // An array of the backtrace()

	public function getTrace();           // Formated string of trace

	/* Overrideable methods inherited from Exception class */

	public function getTraceAsString();                 // formated string for display

	public function __toString();
}

abstract class BaseException extends Exception implements IException {
	protected $message = 'Unknown exception';     // Exception message
	protected $code = 0;                            // Unknown
	protected $file;                       // User-defined exception code
	protected $line;                              // Source filename of exception
	private $string;                              // Source line of exception
	private $trace;                             // Unknown

	public function __construct( $message = null, $code = 0 ) {
		if ( ! $message ) {
			throw new $this( 'Unknown ' . get_class( $this ) );
		}
		parent::__construct( $message, $code );
	}

	public function __toString() {
		return get_class( $this ) . " '{$this->message}' in {$this->file}({$this->line})\n"
		       . "{$this->getTraceAsString()}";
	}
}

class ArgumentError extends BaseException {}
class IOError extends BaseException {}
