<?php

namespace EbsCommon\Wordpress;

use Carbon_Fields\Field;
use EbsCommon\Wordpress\Traits\WordpressHooksTrait;

class AdminComponent extends Component {
	use WordpressHooksTrait;

	public function __construct( $plugin ) {
		parent::__construct( $plugin );
	}

	public function init() {
		parent::init();

		$this->add_action( 'admin_enqueue_scripts', 'enqueue_scripts' );

		$this->add_action( $this->plugin->getPluginSlug( 'register_fields' ), 'registerCarbonFields' );
		$this->add_action( $this->plugin->getPluginSlug( 'register_settings' ), 'addSettings', 10, 1 );
	}

	public function getName() {
		return 'ADMIN_COMPONENT';
	}

	public function registerCarbonFields() {
		$container = $this->create_theme_option_container( 'Settings', $this->getAdminMenuSlug() );

		do_action( $this->plugin->getPluginSlug( 'register_settings' ), $container );
	}

	public function getAdminMenuSlug() {
		return 'ADMIN_MENU_SLUG';
	}

	public function addSettings( $container ) {
//		$container->add_tab( __( 'Modules' ),
//			[
//				Field::make( 'html', 'crb_settings_label_11' )
//				     ->set_html( '<h2>Modules</h2>' ),
//				Field::make( 'checkbox', 'crb_settings_enable_faqs', 'Enable FAQs' ),
//				Field::make( 'checkbox', 'crb_settings_enable_masonry', 'Enable Masonry?' ),
//			] );
	}

	public function dashboardMenuOrder() {
		return - 1;
	}

	/**
	 * Specify position of Top llevel menu in WP Admin menu sidebar
	 *
	 * @return int Top level menu position
	 */
	public function topLevelMenuOrder() {
		return 2;
	}

	/**
	 * @return int Relative order of Settings
	 */
	public function settingsMenuOrder() {
		return 99999;
	}

	public function getAdminMenuTitle() {
		return 'ADMIN MENU';
	}

	public function enqueue_scripts() {
	}

	public function sortAdminMenus( $menu_items ) {
		global $submenu;

		$adminMenuPos = apply_filters( 'admin_menu_order_' . $this->getAdminMenuSlug(), 0 );
		//		 Find own top level menu and move it
		$res      = array_search( $this->getAdminMenuSlug(), $menu_items );
		$our_menu = $menu_items[ $res ];
		unset( $menu_items[ $res ] );

		array_splice( $menu_items, $adminMenuPos, 0, $our_menu );


		$target = &$submenu[ $this->getAdminMenuSlug() ];

		usort( $target,
			function ( $a, $b ) {
				$aO = apply_filters( "admin_menu_order_{$a[2]}", 1 );
				$bO = apply_filters( "admin_menu_order_{$b[2]}", 1 );
				if ( $aO == $bO ) {
					return strcmp( $a[3], $b[3] );
				}

				return $aO > $bO;
			} );

		return $menu_items;
	}

	public function enableCustomMenuOrder() {
		return true;
	}

	public function register_admin_menu_items( $menu_items ) {
		if ( $this->enableDashboard() ) {
			$menu_items[] = [
				'title'  => 'Dashboard',
				'slug'   => 'dashboard',
				'func',
				[ $this, 'render_dashboard_page' ],
				'parent' => $this->getAdminMenuSlug(),
			];
		}

//		if ( $this->enableSettings() ) {
//			$menu_items[] = [
//				'title'  => 'Settings',
//				'slug'   => 'settings',
//				'func'   => [ $this, 'renderSettingsPage' ],
//				'parent' => $this->getAdminMenuSlug(),
//			];
//		}

		return $menu_items;
	}

	public function enableDashboard() {
		return true;
	}

	public function enableSettings() {
		return true;
	}

	public function renderSettingsPage() {
		echo TemplateLoader::render( 'pages/settings.html.twig', [] );
	}


	public function getTitle() {
		return 'EBS Admin';
	}
}