<?php

namespace EbsCommon\Wordpress;

use Twig\Environment;
use Twig\Extension\DebugExtension;
use Twig\Loader\FilesystemLoader;
use Twig\TwigFunction;

class TemplateLoader {
	protected static $global_context = [];
	/**
	 * @var TemplateLoader Singleton instance
	 */
	protected static $instance = null;
	/**
	 * @var FilesystemLoader Base Twig Loader
	 */
	protected static $loader;
	protected static $twig;

	public function __construct() {
		self::$loader = new FilesystemLoader();

		self::$twig = new Environment( self::$loader, [ 'debug' => true ] );
		self::$twig->addExtension( new DebugExtension() );

		self::$twig->addFunction( new TwigFunction( 'plugin_asset', [ $this, 'twig_func_plugin_asset' ] ) );
		self::$twig->addFunction( new TwigFunction( 'do_shortcode', [ $this, 'twig_func_do_shortcode' ] ) );
		self::$twig->addFunction( new TwigFunction( 'html_entity_decode', 'html_entity_decode' ) );
		self::$twig->addFunction( new TwigFunction( 'wp_get_attachment_image_src',
			[ $this, 'wp_get_attachment_image_src' ] ) );
		self::$twig->addFunction( new TwigFunction( 'site_url', [ $this, 'twig_func_site_url' ] ) );
		self::$twig->addFunction( new TwigFunction ( 'language_attributes',
			[ $this, 'twig_func_language_attributes' ] ) );
		self::$twig->addFunction( new TwigFunction ( 'get_bloginfo', [ $this, 'twig_func_get_bloginfo' ] ) );
		self::$twig->addFunction( new TwigFunction ( 'iff', [ $this, 'twig_func_iff' ] ) );
		self::$global_context = [];
	}

	public function wp_get_attachment_image_src( $product, $size ) {
		return wp_get_attachment_image_src( $product->get_image_id() );
	}


	public static function twig_func_plugin_asset( $value ) {
		return self::$global_context['PLUGIN']['base_url'] . 'assets/' . $value;
	}

	public static function twig_func_do_shortcode( $value ) {
		return do_shortcode( $value );
	}

	public static function twig_func_site_url( $value ) {
		return site_url( $value );
	}

	public static function twig_func_language_attributes( $doctype = 'html' ) {
		return get_language_attributes( $doctype );
	}

	public static function twig_func_get_bloginfo( $show, $filter ) {
		return get_bloginfo( $show, $filter );
	}

	public static function twig_func_iff( $if, $then, $else ) {
		if ( $if ) {
			return $then;
		}

		return $else;
	}

	public static function getInstance() {
		if ( self::$instance == null ) {
			self::$instance = new TemplateLoader();
		}

		return self::$instance;
	}

	public static function addTemplatePath( $path ) {
		self::$loader->addPath( $path );
	}

	public static function render( $template, $context = [] ) {
		return self::$twig->render( $template, array_merge( self::$global_context, $context ) );
	}

	public static function setContext( $context ) {
		self::$global_context = array_merge( self::$global_context, $context );
	}
}

TemplateLoader::getInstance();
