<?php

namespace EbsCommon;

function dump( $data, $label = '' ) {
	if ( $label ) {
		$label = "<h1>{$label}</h1>";
	}
	$data_p = print_r( $data, true );

	echo "<div class='ebs-dump'>{$label}<pre>{$data_p}</pre></div>";
}

function joinPaths() {
	$paths    = func_get_args();
	$last_key = func_num_args() - 1;
	array_walk( $paths,
		function ( &$val, $key ) use ( $last_key ) {
			switch ( $key ) {
				case 0:
					$val = rtrim( $val, '/ ' );
					break;
				case $last_key:
					$val = ltrim( $val, '/ ' );
					break;
				default:
					$val = trim( $val, '/ ' );
					break;
			}
		} );

	$first = array_shift( $paths );
	$last  = array_pop( $paths );
	$paths = array_filter( $paths ); // clean empty elements to prevent double slashes
	array_unshift( $paths, $first );
	$paths[] = $last;

	return implode( '/', $paths );
}

function addIf(&$array, $key, $value, $cb=null) {
	$val = boolval($value);

	if ($cb) {
		$val = call_user_func($cb, $value);
	}

	if ($val) {
		$array[$key] = $value;
	}
}

/**
 * Gets a specific property within a multidimensional array.
 *
 * @since  Unknown
 * @access public
 *
 * @param array  $array   The array to search in.
 * @param string $name    The name of the property to find.
 * @param string $default Optional. Value that should be returned if the property is not set or empty. Defaults to null.
 *
 * @return null|string|mixed The value
 */
function rgars( $array, $name, $default = null ) {

	if ( ! is_array( $array ) && ! ( is_object( $array ) && $array instanceof ArrayAccess ) ) {
		return $default;
	}

	$names = explode( '/', $name );
	$val   = $array;
	foreach ( $names as $current_name ) {
		$val = rgar( $val, $current_name, $default );
	}

	return $val;
}

function abs_path_to_url( $path = '' ) {
	$url = str_replace(
		wp_normalize_path( untrailingslashit( ABSPATH ) ),
		site_url(),
		wp_normalize_path( $path )
	);
	return esc_url_raw( $url );
}
