<?php

namespace EbsCommon\Wordpress;

use Carbon_Fields\Container;

class Component {
	/**
	 * Reference to main Plugin
	 *
	 * @since   1.3.2
	 * @access  protected
	 * @var Plugin Reference to main plugin
	 */
	protected $plugin;

	/* Initialize the class and set its properties.
	*
	* @since    1.0.0
	*
	* @param      Plugin $plugin The name of the plugin.
	* @param      string $slug The Component slug
	*/
	public function __construct( $plugin ) {
		$this->plugin = $plugin;

		$this->init();
	}

	protected function init() {}

	public function getLogger( $name = null ) {
		return $this->plugin->get_logger( $name );
	}

	public function getId() {
		return $this->plugin->getName() . '-' . $this->getName();
	}

	public function getName() {
		return 'COMPONENT';
	}

	public function getPluginSlug( $slug ) {
		return $this->plugin->getPluginSlug( $slug );
	}

	/**
	 * Return json encoded response for Ajax calls
	 *
	 * En
	 *
	 * @param mixed $data       Response data
	 * @param int   $statusCode HTTP Response code, default 200
	 * @param bool  $final      End script execution and flush output, default true
	 */
	public function ajaxResponse( $data, $statusCode = 200, $final = true ) {
		header( 'Content-Type: application/json' );
		http_response_code( $statusCode );

		echo json_encode( $data );
		if ( $final ) {
			die;
		}
	}

	/**
	 * Create a base Carbon Fields theme options container
	 *
	 * @param $title string Title for container
	 *
	 * @return Container New container
	 *
	 * @since 1.3.0
	 *
	 */
	protected function create_theme_option_container( $title, $parent ) {
		return Container::make( 'theme_options', $title )
		                ->set_page_parent( $parent );
	}
}
