<?php

namespace EbsCommon\Wordpress;

/**
 * Class AdminMenus
 */
class AdminMenus extends Component {
	protected $menuTitle;
	protected $menuSlug;
	protected $topLevelMenuOrder = 2;
	protected $customMenuOrderEnabled = true;

	/**
	 * AdminMenus constructor.
	 *
	 * @param $plugin Plugin
	 */
	public function __construct( $plugin, $menuTitle='ADMIN_MENU', $menuSlug='ADMIN_MENU_SLUG' ) {
		parent::__construct( $plugin );

		$this->menuSlug  = $menuSlug;
		$this->menuTitle = $menuTitle;
	}

	/**
	 * @return bool
	 */
	public function isCustomMenuOrderEnabled(): bool {
		return $this->customMenuOrderEnabled;
	}

	/**
	 * @param bool $customMenuOrderEnabled
	 *
	 * @return AdminMenus
	 */
	public function setCustomMenuOrderEnabled( bool $customMenuOrderEnabled ) {
		$this->customMenuOrderEnabled = $customMenuOrderEnabled;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getTopLevelMenuOrder(): int {
		return $this->topLevelMenuOrder;
	}

	/**
	 * @param int $topLevelMenuOrder
	 *
	 * @return AdminMenus
	 */
	public function setTopLevelMenuOrder( int $topLevelMenuOrder ) {
		$this->topLevelMenuOrder = $topLevelMenuOrder;

		return $this;
	}

	public function init() {
		add_filter( 'admin_menu', [ $this, 'registerAdminMenus' ] );
		add_filter( 'custom_menu_order', [ $this, 'isCustomMenuOrderEnabled' ] );
		add_filter( 'menu_order', [ $this, 'sortAdminMenus' ], 1000, 1 );
	}

	public function sortAdminMenus( $menu_items ) {
		global $submenu;

		// TODO: Remove deprecated admin_menu_order hook
		$adminMenuPos = apply_filters( $this->getPluginSlug( 'admin_menu_order_' . $this->getMenuSlug() ), 0 );
		$adminMenuPos = apply_filters( 'admin_menu_order_' . $this->getMenuSlug(), $adminMenuPos );

		//		 Find own top level menu and move it
		$res      = array_search( $this->getMenuSlug(), $menu_items );
		$our_menu = $menu_items[ $res ];
		unset( $menu_items[ $res ] );

		array_splice( $menu_items, $this->topLevelMenuOrder, 0, $our_menu );

		$target = &$submenu[ $this->getMenuSlug() ];

		if ( is_null( $target ) ) {
			return $menu_items;
		}

		usort( $target,
			function ( $a, $b ) {
				// TODO: Remove deprecated admin_menu_order hook
				$aO = apply_filters( $this->getPluginSlug( "admin_menu_order_{$a[2]}" ), 1 );
				$aO = apply_filters( "admin_menu_order_{$a[2]}", $aO );

				// TODO: Remove deprecated admin_menu_order hook
				$bO = apply_filters( $this->getPluginSlug( "admin_menu_order_{$b[2]}" ), 1 );
				$bO = apply_filters( "admin_menu_order_{$b[2]}", $bO );

				if ( $aO == $bO ) {
					return strcmp( $a[3], $b[3] );
				}

				return $aO > $bO;
			} );

		return $menu_items;
	}

	/**
	 * @return mixed
	 */
	public function getMenuSlug() {
		return $this->menuSlug;
	}

	/**
	 * @param mixed $menuSlug
	 *
	 * @return AdminMenus
	 */
	public function setMenuSlug( $menuSlug ) {
		$this->menuSlug = $menuSlug;

		return $this;
	}

	/**
	 *
	 */
	public function registerAdminMenus() {
		add_menu_page(
			$this->getMenuTitle(),
			$this->getMenuTitle(),
			'manage_options',
			$this->getMenuSlug(),
			null,
			'dashicons-admin-generic',
			26
		);

		// Add dummy entry to allow removal of duplicate EBS Settings submenu
		add_submenu_page(
			$this->getMenuSlug(),
			'',
			'',
			'manage_options',
			$this->getMenuSlug(),
			null
		);

		remove_submenu_page( $this->getMenuSlug(), $this->getMenuSlug() );

		$menu_items = apply_filters( 'register_admin_menu_items', [] );
		$menu_items = apply_filters( $this->getPluginSlug( 'admin_menu_items' ), $menu_items );

		foreach ( $menu_items as $menu ) {
			add_submenu_page(
				( isset( $menu['parent'] ) ? $menu['parent'] : $this->getMenuSlug() ),
				$menu['title'],
				$menu['title'],
				isset( $menu['caps'] ) ? $menu['caps'] : 'manage_options',
				$menu['slug'],
				isset( $menu['func'] ) ? $menu['func'] : null
			);
		}
	}

	/**
	 * @return mixed
	 */
	public function getMenuTitle() {
		return $this->menuTitle;
	}

	/**
	 * @param mixed $menuTitle
	 */
	public function setMenuTitle( $menuTitle ) {
		$this->menuTitle = $menuTitle;

		return $this;
	}
}
