<?php

namespace EbsCommon\Wordpress\Modules;

/**
 * FAQs module
 *
 * @link       https://everbearingservices.com
 * @since      1.0.0
 *
 * @package    EbsCommon
 * @subpackage EbsCommon/includes/components/public
 */

use Carbon_Fields\Container;
use Carbon_Fields\Field;
use EbsCommon\Wordpress\Component;
use EbsCommon\Wordpress\TemplateLoader;

/**
 * FAQs module
 *
 * @package    EbsCommon
 * @author     Everbearing Services <info@everbearingservices.com>
 */
class TestimonialsComponent extends Component {
	protected $testimonials;

	public function __construct( $plugin ) {
		parent::__construct( $plugin );
	}

	/**
	 *
	 * Module initialization
	 *
	 * @since 1.0.0
	 */
	protected function init() {
		parent::init();

		add_shortcode( 'testimonials',
			function ( $atts ) {
				$atts = shortcode_atts( [
					'format' => 'columns',
					'count'  => - 1,
				],
					$atts,
					'faqs' );

				if ( is_null( $this->testimonials ) ) {
					$this->testimonials = carbon_get_theme_option( 'crb_testimonials' );
				}

				$testimonials = $this->testimonials;
				if ( $atts['count'] > - 1 ) {
					$testimonials = array_slice( $this->testimonials, 0, $atts['count'] );
				}

				foreach ( $testimonials as &$testimonial ) {
					$testimonial['body'] = do_shortcode( $testimonial['body'], false );
				}

				return TemplateLoader::render( 'public/testimonials.html.twig',
					[
						'format' => $atts['format'],
						'testimonials' => $testimonials,
					] );
			} );
	}

	public function registerCarbonFields(): void {
		$parentSlug = $this->plugin->getComponent( 'adminMenus' )->getMenuSlug();

		Container::make( 'theme_options', 'Testimonials' )
		         ->set_page_parent( $parentSlug )
		         ->add_fields( [
			         Field::make( 'complex', 'crb_testimonials', __( 'Testimonials', 'lpo-custom' ) )
			              ->set_layout( 'tabbed-vertical' )
			              ->add_fields( [
				              Field::make( 'text', 'name', 'Testimonial Author Name' )
				                   ->set_help_text( 'Author first/last name' ),
				              Field::make( 'textarea', 'body', 'Testimonial Text' )
				                   ->set_required( true )
				                   ->set_help_text( 'Use HTML for formatting' ),
			              ] )
			              ->set_header_template( '
					         <% if (name) { %>
					         <%- name %>
					         <% } else { Testimonial }%>
	  			          ' ),
		         ] );
	}
}
