<?php
$config = json_decode(file_get_contents(__DIR__ . '/../config.json'), true);

$replacements = $config['tokens'];

$sourceDir = __DIR__ . '/../templates';
$destDir = realpath(__DIR__ . '/../') . '/' . ($config['slug'] ?? $config['SLUG'] ?? 'plugin');

// create the main plugin directory if it doesn't exist
if (!is_dir($destDir)) {
    mkdir($destDir, 0755, true);
}

$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($sourceDir));

foreach ($files as $file) {
    if ($file->isFile()) {
        $relativePath = str_replace($sourceDir, '', $file->getRealPath());
        $targetPath = $destDir . $relativePath;

        // create the target directory if it doesn't exist
        if (!is_dir(dirname($targetPath))) {
            mkdir(dirname($targetPath), 0755, true);
        }

        $contents = file_get_contents($file->getRealPath());
        $newContents = str_replace(array_keys($replacements), array_values($replacements), $contents);
        file_put_contents($targetPath, $newContents);
    }
}
echo "Template generation complete. Plugin scaffolded in: $destDir\n";
