<?php
require_once __DIR__ . '/../vendor/autoload.php';

use Symfony\Component\Console\Question\Question;
use Symfony\Component\Console\Helper\QuestionHelper;
use Symfony\Component\Console\Output\ConsoleOutput;
use Symfony\Component\Console\Input\ArgvInput;

$output = new ConsoleOutput();
$input = new ArgvInput();
$helper = new QuestionHelper();

$questions = [
    [
        'name' => 'author',
        'token' => '__X_AUTHOR__',
        'description' => 'Author Name',
        'example' => 'Joel Madigan',
    ],
    [
        'name' => 'author_email',
        'token' => '__X_AUTHOR_EMAIL__',
        'description' => 'Author Email',
        'example' => 'jmadigan@everbearingservices.com',
    ],
    [
        'name' => 'id',
        'token' => '__X_ID__',
        'description' => 'Plugin ID',
        'example' => 'ebs_common_skeleton',
    ],
    [
        'name' => 'id_caps',
        'token' => '__X_ID_CAPS__',
        'description' => 'Plugin ID Caps',
        'example' => 'EBS_COMMON_SKELETON',
    ],
    [
        'name' => 'slug',
        'token' => '__X_SLUG__',
        'description' => 'Plugin Slug',
        'example' => 'ebs-common-skeleton',
    ],
    [
        'name' => 'title',
        'token' => '__X_TITLE__',
        'description' => 'Plugin Title',
        'example' => 'EBS Common Skeleton',
    ],
    [
        'name' => 'description',
        'token' => '__X_DESCRIPTION__',
        'description' => 'Plugin Description',
        'example' => 'Reference implementation of EbsCommon',
    ],
    [
        'name' => 'initial_version',
        'token' => '__X_INITIAL_VERSION__',
        'description' => 'Initial Version',
        'example' => '1.0.0',
    ],
    [
        'name' => 'class_namespace',
        'token' => '__X_CLASS_NAMESPACE__',
        'description' => 'PHP Namespace',
        'example' => 'EbsCommon_Skeleton',
    ],
    [
        'name' => 'site_user',
        'token' => '__X_SITE_USER__',
        'description' => 'EBSDEV Unix user for site',
        'example' => 'testbed',
    ],
    [
        'name' => 'destination',
        'token' => '__X_DESTINATION__',
        'description' => 'Output path',
        'type' => 'path',
        'example' => '../test'
    ]
];

$config = [];

foreach ($questions as $questionData) {
    $name = $questionData['name'];
    $description = $questionData['description'];
    $example = $questionData['example'];
    $token = $questionData['token'];
    
    $questionText = "$description";
    if (isset($example)) {
        $questionText .= " (e.g. $example)";
    }
    
    $question = new Question("$questionText: ", $example);
    $response = $helper->ask($input, $output, $question);
    
    $config[$name] = $response;
    $config['tokens'][$token] = $response;
}

file_put_contents(__DIR__ . '/../config.json', json_encode($config, JSON_PRETTY_PRINT));
echo "Configuration saved.\n";
