# Create EBS Plugin

A project skeleton generator for creating WordPress plugins with EBS Common.

## Overview

This tool provides a streamlined way to scaffold new WordPress plugins that use the EBS Common framework. It generates all the necessary files and structure based on your inputs, saving development time and ensuring consistency across projects.

## Installation

```bash
composer create-project ebsdev/create-ebs-plugin your-plugin-name
```

## Usage

After installation, the tool will:

1. Prompt you for plugin details (ID, name, description, etc.)
2. Generate the plugin structure based on your inputs
3. Initialize a Git repository with an initial commit

### Configuration Options

The tool will ask for the following information:

- **Author Name**: Your name
- **Author Email**: Your email address
- **Plugin ID**: Internal identifier (e.g., `ebs_common_skeleton`)
- **Plugin ID Caps**: Uppercase version for constants (e.g., `EBS_COMMON_SKELETON`)
- **Plugin Slug**: Hyphenated name for directories/files (e.g., `ebs-common-skeleton`)
- **Plugin Title**: Human-readable name (e.g., `EBS Common Skeleton`)
- **Plugin Description**: Brief explanation of functionality
- **Initial Version**: Starting version number (e.g., `1.0.0`)
- **PHP Namespace**: For plugin classes (e.g., `EbsCommon_Skeleton`)
- **EBSDEV Unix User**: Site user for deployment
- **Output Path**: Where to create the plugin

## Project Structure

The generated plugin will include:

- WordPress plugin header file
- Composer configuration
- PSR-4 autoloading
- EBS Common integration
- Basic component structure
- Deployment configuration

## Development

After generation, you can:

- Use `composer` commands to manage dependencies
- Use `npm run sync` to deploy to development environments
- Extend the plugin by adding components in the `includes` directory

## Changelog

### v0.1.0 - 2025-05-10

+ Initial version

## License

UNLICENSED

